# WORKING TEST SCRIPT - This will send hero_images[] correctly

$token = "hc7CtZwXYp1iyHuvaNlxU7LOiHnigzyv9uVPKkWfab102d49"

# Find available images
Write-Host "Finding available images..." -ForegroundColor Cyan
$images = Get-ChildItem "C:\Users\gamer\Downloads\" -File | Where-Object {
    $_.Extension -match '\.(jpg|jpeg|png|webp)$'
} | Select-Object -First 3

if ($images.Count -lt 2) {
    Write-Host "ERROR: Need at least 2 image files!" -ForegroundColor Red
    Write-Host "Please add some .jpg, .png, or .webp files to your Downloads folder" -ForegroundColor Yellow
    exit 1
}

$file1 = $images[0].FullName
$file2 = $images[1].FullName
$file3 = if ($images.Count -gt 2) { $images[2].FullName } else { $file2 }

Write-Host "Using files:" -ForegroundColor Green
Write-Host "  1. $file1" -ForegroundColor White
Write-Host "  2. $file2" -ForegroundColor White
Write-Host "  3. $file3" -ForegroundColor White
Write-Host ""

# THE IMPORTANT PART - ALL THREE --form FIELDS
Write-Host "Sending request with hero_image AND hero_images[]..." -ForegroundColor Yellow
Write-Host ""

$response = curl.exe --location "http://localhost:8000/api/sections/footer" `
    --header "Accept: application/json" `
    --header "Authorization: Bearer $token" `
    --form "Header=TESTING_ARRAY_UPLOAD" `
    --form "hero_image=@$file1" `
    --form "hero_images[]=@$file2" `
    --form "hero_images[]=@$file3"

Write-Host "Response:" -ForegroundColor Cyan
$response | ConvertFrom-Json | ConvertTo-Json -Depth 10

Write-Host ""
Write-Host "Now check the logs - you should see:" -ForegroundColor Yellow
Write-Host '  "raw_files":["hero_image","hero_images"]' -ForegroundColor Green
Write-Host ""
Write-Host "Run: Get-Content storage/logs/laravel.log -Tail 5" -ForegroundColor Gray
