# PowerShell test upload script with CORRECT syntax
# Run this: .\test-upload.ps1

$TOKEN = "kOEyps2WyRn1tsZyIEHXUzg65VYL8I9ACWJ1Rn1q298fe5eb"
$URL = "http://localhost:8000/api/sections/footer"

Write-Host "=== Testing Multiple Image Upload ===" -ForegroundColor Green
Write-Host ""

# Method 1: Using curl with proper escaping (if curl is available)
Write-Host "Uploading with curl..." -ForegroundColor Yellow

curl --location $URL `
  --header 'Accept: application/json' `
  --header "Authorization: Bearer $TOKEN" `
  --form 'title="Footer Section"' `
  --form 'hero_image=@"C:/Users/gamer/Downloads/shutterstock_141945937.webp"' `
  --form 'hero_images[]=@"C:/Users/gamer/Downloads/golden-retriever-dog-breed-info.jpeg"' `
  --form 'hero_images[]=@"C:/Users/gamer/Downloads/shutterstock_141945937.webp"'

Write-Host ""
Write-Host "=== Upload Complete ===" -ForegroundColor Green

# Alternative Method 2: Using Invoke-WebRequest (PowerShell native)
Write-Host ""
Write-Host "=== Alternative: Using PowerShell Invoke-WebRequest ===" -ForegroundColor Cyan

$form = @{
    title = "Footer Section"
    hero_image = Get-Item -Path "C:\Users\gamer\Downloads\shutterstock_141945937.webp"
    'hero_images[]' = @(
        Get-Item -Path "C:\Users\gamer\Downloads\golden-retriever-dog-breed-info.jpeg"
        Get-Item -Path "C:\Users\gamer\Downloads\shutterstock_141945937.webp"
    )
}

$headers = @{
    'Accept' = 'application/json'
    'Authorization' = "Bearer $TOKEN"
}

try {
    $response = Invoke-WebRequest -Uri $URL -Method POST -Form $form -Headers $headers
    Write-Host "Response:" -ForegroundColor Green
    $response.Content | ConvertFrom-Json | ConvertTo-Json -Depth 10
} catch {
    Write-Host "Error: $_" -ForegroundColor Red
}





