<?php
/**
 * Simple PHP test script to upload files to sections API
 * Run: php test-simple.php
 */

$apiUrl = 'http://localhost:8000/api/sections/footer';
$token = 'hc7CtZwXYp1iyHuvaNlxU7LOiHnigzyv9uVPKkWfab102d49';

// Find image files in Downloads folder
$downloadsPath = 'C:/Users/gamer/Downloads/';
$files = glob($downloadsPath . '*.{jpg,jpeg,png,webp}', GLOB_BRACE);

if (count($files) < 2) {
    die("Error: Need at least 2 image files in Downloads folder\n");
}

$file1 = $files[0];
$file2 = $files[1];
$file3 = isset($files[2]) ? $files[2] : $files[1];

echo "Using files:\n";
echo "  1. $file1\n";
echo "  2. $file2\n";
echo "  3. $file3\n\n";

// Build multipart form data
$boundary = uniqid();
$delimiter = '-------------' . $boundary;

$postData = multipartBuild([
    'Header' => 'PHP_TEST_UPLOAD',
    'hero_image' => new CURLFile($file1),
    'hero_images' => [
        new CURLFile($file2),
        new CURLFile($file3),
    ]
], $delimiter);

// Send request
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: multipart/form-data; boundary=' . $delimiter,
    'Accept: application/json',
    'Authorization: Bearer ' . $token,
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Response ($httpCode):\n";
echo json_encode(json_decode($response), JSON_PRETTY_PRINT);
echo "\n\n";
echo "Check logs: Get-Content storage/logs/laravel.log -Tail 5\n";
echo 'Should show: "raw_files":["hero_image","hero_images"]' . "\n";

function multipartBuild($fields, $boundary) {
    $data = '';

    foreach ($fields as $name => $value) {
        if (is_array($value)) {
            foreach ($value as $val) {
                $data .= "--" . $boundary . "\r\n";
                if ($val instanceof CURLFile) {
                    $data .= 'Content-Disposition: form-data; name="' . $name . '[]"; filename="' . basename($val->getFilename()) . '"' . "\r\n";
                    $data .= 'Content-Type: ' . mime_content_type($val->getFilename()) . "\r\n\r\n";
                    $data .= file_get_contents($val->getFilename()) . "\r\n";
                }
            }
        } else {
            $data .= "--" . $boundary . "\r\n";
            if ($value instanceof CURLFile) {
                $data .= 'Content-Disposition: form-data; name="' . $name . '"; filename="' . basename($value->getFilename()) . '"' . "\r\n";
                $data .= 'Content-Type: ' . mime_content_type($value->getFilename()) . "\r\n\r\n";
                $data .= file_get_contents($value->getFilename()) . "\r\n";
            } else {
                $data .= 'Content-Disposition: form-data; name="' . $name . '"' . "\r\n\r\n";
                $data .= $value . "\r\n";
            }
        }
    }

    $data .= "--" . $boundary . "--\r\n";
    return $data;
}
