# Test script for hero_images upload to sections API

# Configuration
$apiUrl = "http://localhost:8000/api/sections/footer"
$token = "hc7CtZwXYp1iyHuvaNlxU7LOiHnigzyv9uVPKkWfab102d49"

# Image files to upload
$image1 = "C:\Users\gamer\Downloads\shutterstock_141945937.webp"
$image2 = "C:\Users\gamer\Downloads\golden-retriever-dog-breed-info.jpeg"

Write-Host "Testing hero_images upload..." -ForegroundColor Cyan
Write-Host "API Endpoint: $apiUrl" -ForegroundColor Yellow
Write-Host ""

# Check if files exist
if (-Not (Test-Path $image1)) {
    Write-Host "Error: Image 1 not found at $image1" -ForegroundColor Red
    exit 1
}

if (-Not (Test-Path $image2)) {
    Write-Host "Error: Image 2 not found at $image2" -ForegroundColor Red
    exit 1
}

Write-Host "Files found:" -ForegroundColor Green
Write-Host "  - $image1"
Write-Host "  - $image2"
Write-Host ""

# Build the curl command
$curlCommand = @"
curl --location '$apiUrl' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer $token' \
--form 'Header="Test Header Value"' \
--form 'hero_image=@"$image1"' \
--form 'hero_images[]=@"$image1"' \
--form 'hero_images[]=@"$image2"'
"@

Write-Host "Executing curl command..." -ForegroundColor Cyan
Write-Host $curlCommand -ForegroundColor Gray
Write-Host ""

# Execute the curl command
$response = curl --location $apiUrl `
    --header 'Accept: application/json' `
    --header "Authorization: Bearer $token" `
    --form 'Header="Test Header Value"' `
    --form "hero_image=@`"$image1`"" `
    --form "hero_images[]=@`"$image1`"" `
    --form "hero_images[]=@`"$image2`""

# Parse and display the response
Write-Host "Response:" -ForegroundColor Green
Write-Host $response | ConvertFrom-Json | ConvertTo-Json -Depth 10

Write-Host ""
Write-Host "Checking logs..." -ForegroundColor Cyan
Write-Host "Run the following to see debug logs:" -ForegroundColor Yellow
Write-Host "  tail -n 50 storage/logs/laravel.log" -ForegroundColor Gray
Write-Host "  # Or on Windows:"
Write-Host "  Get-Content storage/logs/laravel.log -Tail 50" -ForegroundColor Gray
