# Corrected test script for hero_images upload

# Configuration
$apiUrl = "http://localhost:8000/api/sections/footer"
$token = "hc7CtZwXYp1iyHuvaNlxU7LOiHnigzyv9uVPKkWfab102d49"

# Find available image files in Downloads folder
$downloadsPath = "C:\Users\gamer\Downloads"
$imageFiles = Get-ChildItem -Path $downloadsPath -File | Where-Object {
    $_.Extension -match '\.(jpg|jpeg|png|webp)$'
} | Select-Object -First 3

if ($imageFiles.Count -lt 2) {
    Write-Host "Error: Need at least 2 image files in Downloads folder" -ForegroundColor Red
    Write-Host "Available files:" -ForegroundColor Yellow
    Get-ChildItem -Path $downloadsPath -File | Where-Object {
        $_.Extension -match '\.(jpg|jpeg|png|webp)$'
    } | ForEach-Object { Write-Host "  - $($_.FullName)" }
    exit 1
}

$heroImage = $imageFiles[0].FullName
$arrayImage1 = $imageFiles[1].FullName
$arrayImage2 = if ($imageFiles.Count -gt 2) { $imageFiles[2].FullName } else { $imageFiles[1].FullName }

Write-Host "==================================================" -ForegroundColor Cyan
Write-Host "Testing hero_images[] Upload to Sections API" -ForegroundColor Cyan
Write-Host "==================================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "Using files:" -ForegroundColor Green
Write-Host "  hero_image    : $heroImage" -ForegroundColor White
Write-Host "  hero_images[0]: $arrayImage1" -ForegroundColor White
Write-Host "  hero_images[1]: $arrayImage2" -ForegroundColor White
Write-Host ""

# Build the curl command - IMPORTANT: No quotes around file paths after @
$curlCmd = "curl --location `"$apiUrl`" " +
           "--header `"Accept: application/json`" " +
           "--header `"Authorization: Bearer $token`" " +
           "--form `"Header=Testing Array Upload`" " +
           "--form `"hero_image=@$heroImage`" " +
           "--form `"hero_images[]=@$arrayImage1`" " +
           "--form `"hero_images[]=@$arrayImage2`""

Write-Host "Executing command..." -ForegroundColor Yellow
Write-Host $curlCmd -ForegroundColor Gray
Write-Host ""

# Execute
Invoke-Expression $curlCmd | ConvertFrom-Json | ConvertTo-Json -Depth 10

Write-Host ""
Write-Host "==================================================" -ForegroundColor Cyan
Write-Host "Check the logs to verify files were received:" -ForegroundColor Yellow
Write-Host "  Get-Content storage/logs/laravel.log -Tail 20" -ForegroundColor Gray
Write-Host ""
Write-Host "Look for:" -ForegroundColor Yellow
Write-Host '  "raw_files":["hero_image","hero_images"]' -ForegroundColor White
Write-Host "  (Should show both fields, not just hero_image)" -ForegroundColor Gray
