# Test Client CRUD operations
# Make sure to replace the token with a valid one from your auth system

$baseUrl = "http://localhost:8000/api"
$token = "YOUR_AUTH_TOKEN_HERE"

$headers = @{
    "Authorization" = "Bearer $token"
    "Accept" = "application/json"
    "Content-Type" = "application/json"
}

Write-Host "Testing Client CRUD operations..." -ForegroundColor Green

# Test 1: Create a client
Write-Host "`n1. Creating a client..." -ForegroundColor Yellow
$createData = @{
    name = "Test Client"
} | ConvertTo-Json

try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients" -Method POST -Headers $headers -Body $createData
    Write-Host "Client created successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
    $clientId = $response.id
} catch {
    Write-Host "Error creating client: $($_.Exception.Message)" -ForegroundColor Red
    exit 1
}

# Test 2: Get all clients
Write-Host "`n2. Getting all clients..." -ForegroundColor Yellow
try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients" -Method GET -Headers $headers
    Write-Host "Clients retrieved successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error getting clients: $($_.Exception.Message)" -ForegroundColor Red
}

# Test 3: Get specific client
Write-Host "`n3. Getting client by ID..." -ForegroundColor Yellow
try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients/$clientId" -Method GET -Headers $headers
    Write-Host "Client retrieved successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error getting client: $($_.Exception.Message)" -ForegroundColor Red
}

# Test 4: Update client
Write-Host "`n4. Updating client..." -ForegroundColor Yellow
$updateData = @{
    name = "Updated Test Client"
} | ConvertTo-Json

try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients/$clientId" -Method PUT -Headers $headers -Body $updateData
    Write-Host "Client updated successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error updating client: $($_.Exception.Message)" -ForegroundColor Red
}

# Test 5: Find client by name
Write-Host "`n5. Finding client by name..." -ForegroundColor Yellow
try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients/name/Updated%20Test%20Client" -Method GET -Headers $headers
    Write-Host "Client found by name:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error finding client by name: $($_.Exception.Message)" -ForegroundColor Red
}

# Test 6: Upsert client by name
Write-Host "`n6. Upserting client by name..." -ForegroundColor Yellow
$upsertData = @{
    name = "Upserted Client"
} | ConvertTo-Json

try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients/upsert/Upserted%20Client" -Method POST -Headers $headers -Body $upsertData
    Write-Host "Client upserted successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error upserting client: $($_.Exception.Message)" -ForegroundColor Red
}

# Test 7: Delete client
Write-Host "`n7. Deleting client..." -ForegroundColor Yellow
try {
    $response = Invoke-RestMethod -Uri "$baseUrl/clients/$clientId" -Method DELETE -Headers $headers
    Write-Host "Client deleted successfully:" -ForegroundColor Green
    $response | ConvertTo-Json -Depth 3
} catch {
    Write-Host "Error deleting client: $($_.Exception.Message)" -ForegroundColor Red
}

Write-Host "`nClient CRUD testing completed!" -ForegroundColor Green





