<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($subject); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #4F46E5;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background-color: #f9f9f9;
            padding: 30px;
            border-radius: 0 0 8px 8px;
        }
        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #4F46E5;
        }
        .body-content {
            white-space: pre-wrap;
            margin-bottom: 20px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            color: #666;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e(config('app.name')); ?></h1>
    </div>
    <div class="content">
        <div class="greeting">
            Hello <?php echo e($recipientName); ?>,
        </div>
        <div class="body-content">
            <?php echo e($body); ?>

        </div>
        <div class="footer">
            <p>This is an automated email from <?php echo e(config('app.name')); ?>.</p>
            <p>Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\gamer\Documents\backend\resources\views/emails/generic.blade.php ENDPATH**/ ?>