<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;

// Guest accessible routes (read-only)
Route::get('/users', [UserController::class, 'index']);
Route::get('/users/email/{email}', [UserController::class, 'findByEmail']);
Route::get('/users/{id}', [UserController::class, 'show']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    // CRUD operations
    Route::post('/users', [UserController::class, 'store']);
    Route::post('/users/{id}', [UserController::class, 'update']);
    Route::delete('/users/{id}', [UserController::class, 'destroy']);

    // Soft delete management
    Route::get('/users/trashed/all', [UserController::class, 'trashed']);
    Route::post('/users/{id}/restore', [UserController::class, 'restore']);
    Route::delete('/users/{id}/force', [UserController::class, 'forceDestroy']);
});
