<?php

use App\Http\Controllers\SettingController;
use Illuminate\Support\Facades\Route;

// Public setting routes (no authentication required)
Route::prefix('settings')->group(function () {
    // List all settings
    Route::get('/', [SettingController::class, 'index']);

    // Show specific setting by name
    Route::get('/{name}', [SettingController::class, 'show']);
});

// Authenticated setting routes (require authentication)
Route::prefix('settings')->middleware('auth:sanctum')->group(function () {
    // Create or update setting by name
    Route::post('/{name}', [SettingController::class, 'upsert']);

    // Delete setting by name
    Route::delete('/{name}', [SettingController::class, 'destroy']);
});
