<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SectorController;

// Guest accessible routes (read-only)
Route::get('/sectors', [SectorController::class, 'index']);
Route::get('/sectors/{name}', [SectorController::class, 'show']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/sectors/{name}', [SectorController::class, 'upsert']);
    Route::delete('/sectors/{name}', [SectorController::class, 'destroy']);
});
