<?php

use App\Http\Controllers\SectionController;
use Illuminate\Support\Facades\Route;

// Public section routes (no authentication required)
Route::prefix('sections')->group(function () {
    // List all sections
    Route::get('/', [SectionController::class, 'index']);

    // Show specific section by name
    Route::get('/{name}', [SectionController::class, 'show']);
});

// Authenticated section routes (require authentication)
Route::prefix('sections')->middleware('auth:sanctum')->group(function () {
    // Create or update section by name
    Route::post('/{name}', [SectionController::class, 'upsert']);

    // Delete section by name
    Route::delete('/{name}', [SectionController::class, 'destroy']);
});
