<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProjectController;

// Guest accessible routes (read-only)
Route::get('/projects', [ProjectController::class, 'index']);
Route::get('/projects/{name}', [ProjectController::class, 'show']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/projects/{name}', [ProjectController::class, 'upsert']);
    Route::delete('/projects/{name}', [ProjectController::class, 'destroy']);
});
