<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MailController;

// Public routes (no authentication required)
// Contact form - anyone can submit
Route::post('/mails', [MailController::class, 'contactForm']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/mails', action: [MailController::class, 'index']);

    Route::get('/mails/{id}', [MailController::class, 'show']);

    Route::delete('/mails/{id}', [MailController::class, 'destroy']);
});
