<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClientController;

// Guest accessible routes (read-only)
Route::get('/clients', [ClientController::class, 'index']);
Route::get('/clients/{name}', [ClientController::class, 'show']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/clients/{name}', [ClientController::class, 'upsert']);
    Route::delete('/clients/{name}', [ClientController::class, 'destroy']);
});
