<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            // Drop foreign key constraints first
            $table->dropForeign(['client_id']);
            $table->dropForeign(['sector_id']);

            // Then drop the columns
            $table->dropColumn(['description', 'image', 'client_id', 'sector_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->string('description')->nullable()->after('name');
            $table->string('image')->nullable()->after('description');
            $table->foreignId('client_id')->nullable()->constrained('clients')->after('body');
            $table->foreignId('sector_id')->nullable()->constrained('sectors')->after('client_id');
        });
    }
};

