<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('mails', function (Blueprint $table) {
            $table->timestamp('sent_at')->nullable()->after('status');
            $table->string('recipient_type')->nullable()->after('sent_at'); // 'user' or 'client'
            $table->unsignedBigInteger('recipient_id')->nullable()->after('recipient_type');
            $table->text('error_message')->nullable()->after('recipient_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mails', function (Blueprint $table) {
            $table->dropColumn(['sent_at', 'recipient_type', 'recipient_id', 'error_message']);
        });
    }
};
