<?php

namespace App\Services;

use App\Models\Client;
use Illuminate\Support\Facades\Auth;

class ClientService
{
    use FlexibleBodyTrait;

    public function listAll()
    {
        return Client::with(['addedBy', 'updatedBy'])->get();
    }

    public function findById(int $id): ?Client
    {
        return Client::with(['addedBy', 'updatedBy'])->find($id);
    }

    public function findByName(string $name): ?Client
    {
        return Client::where('name', $name)
            ->with(['addedBy', 'updatedBy'])
            ->first();
    }

    public function upsertByName(string $name, array $bodyData, array $files = []): Client
    {
        $userId = Auth::id();

        // Get existing client to handle image cleanup
        $existingClient = Client::where('name', $name)->first();
        $existingBody = $existingClient ? $this->getRawBodyData($existingClient) : null;

        // Process image uploads and merge with body data
        $processedData = $this->processImageUploads($bodyData, $files, $existingBody, 'clients');

        $client = Client::updateOrCreate(
            ['name' => $name],
            [
                'body' => $processedData,
                'updated_by' => $userId,
                'added_by' => $userId,
            ]
        );

        return $client->load(['addedBy', 'updatedBy']);
    }

    public function deleteByName(string $name): bool
    {
        $client = Client::where('name', $name)->first();
        if (!$client) {
            return false;
        }

        // Delete all images associated with this client
        $body = $this->getRawBodyData($client);
        $this->deleteAllImages($body);

        $client->delete();
        return true;
    }
}
