<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mail extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'email',
        'subject',
        'body',
        'status',
        'sent_at',
        'recipient_type',
        'recipient_id',
        'error_message'
    ];

    protected $casts = [
        'sent_at' => 'datetime',
    ];

    /**
     * Get the recipient (User or Client)
     */
    public function recipient()
    {
        if ($this->recipient_type === 'user') {
            return $this->belongsTo(User::class, 'recipient_id');
        } elseif ($this->recipient_type === 'client') {
            return $this->belongsTo(Client::class, 'recipient_id');
        }
        return null;
    }
}
