<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Services\AuthService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    protected AuthService $authService;

    public function __construct(AuthService $authService)
    {
        $this->authService = $authService;
    }


    /**
     * Login user
     *
     * @param LoginRequest $request
     * @return JsonResponse
     */
    public function login(LoginRequest $request): JsonResponse
    {
        $result = $this->authService->login($request->validated());

        if ($result['success']) {
            return response()->json([
                'message' => $result['message'],
                'user' => $result['data']['user'],
                'access_token' => $result['data']['access_token'],
                'token_type' => $result['data']['token_type'],
                'expires_in' => $result['data']['expires_in']
            ], 200);
        }

        return response()->json([
            'message' => $result['message']
        ], 401);
    }

    /**
     * Logout user
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function logout(Request $request): JsonResponse
    {
        $user = $request->user();
        $result = $this->authService->logout($user);

        if ($result['success']) {
            return response()->json([
                'message' => $result['message']
            ], 200);
        }

        return response()->json([
            'message' => $result['message']
        ], 500);
    }

    /**
     * Get authenticated user
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function me(Request $request): JsonResponse
    {
        $result = $this->authService->getAuthenticatedUser();

        if ($result['success']) {
            return response()->json([
                'message' => $result['message'],
                'user' => $result['data']['user']
            ], 200);
        }

        return response()->json([
            'message' => $result['message']
        ], 401);
    }

}
