# Setting Module - Quick Reference

## Files Created/Modified

### New Files:
- ✅ `app/Services/SettingService.php` - Service layer for settings CRUD operations
- ✅ `app/Http/Controllers/SettingController.php` - API controller
- ✅ `routes/settings.php` - Settings routes
- ✅ `SETTING_MODULE_DOCUMENTATION.md` - Full documentation

### Modified Files:
- ✅ `app/Models/Setting.php` - Added fillable fields and body accessor
- ✅ `database/migrations/2025_10_05_175554_create_settings_table.php` - Updated to use name/body structure
- ✅ `routes/api.php` - Registered settings routes

## Database Structure

```
settings
├── id
├── name (unique) - e.g., "general", "social_media", "contact"
├── body (json) - stores any data structure
├── added_by
├── updated_by
├── created_at
├── updated_at
└── deleted_at
```

## API Endpoints

### Public (No Auth)
- `GET /api/settings` - List all settings
- `GET /api/settings/{name}` - Get specific setting

### Authenticated (Sanctum Token Required)
- `POST /api/settings/{name}` - Create/Update setting
- `DELETE /api/settings/{name}` - Delete setting

## Quick Examples

### Create General Website Settings
```bash
curl -X POST http://localhost/api/settings/general \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "website_name": "My Website",
    "tagline": "Your Success Partner",
    "email": "info@example.com"
  }'
```

### Create Social Media Settings
```bash
curl -X POST http://localhost/api/settings/social_media \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "facebook": "https://facebook.com/mypage",
    "twitter": "https://twitter.com/myhandle",
    "linkedin": "https://linkedin.com/company/mycompany",
    "instagram": "https://instagram.com/myprofile"
  }'
```

### Upload Logo/Branding Images
```bash
curl -X POST http://localhost/api/settings/branding \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "logo_image=@/path/to/logo.png" \
  -F "favicon_image=@/path/to/favicon.ico" \
  -F "brand_color=#007bff"
```

### Get Settings
```bash
# Get all settings
curl http://localhost/api/settings

# Get specific setting
curl http://localhost/api/settings/general
```

## Features

✅ **Flexible JSON Storage** - Store any data structure
✅ **Automatic Image Handling** - Fields ending with `_image` or `_images`
✅ **Base64 Support** - Send images as base64 strings
✅ **Public Read Access** - Anyone can fetch settings
✅ **Authenticated Write** - Only authenticated users can modify
✅ **Automatic Cleanup** - Old images deleted on update/delete
✅ **User Tracking** - Tracks who created/updated
✅ **Soft Deletes** - Can recover deleted settings

## Common Setting Types

1. **general** - website_name, tagline, description, copyright
2. **social_media** - facebook, twitter, linkedin, instagram, youtube
3. **contact** - email, phone, address, business_hours
4. **branding** - logo_image, favicon_image, brand_color, secondary_color
5. **seo** - meta_title, meta_description, meta_keywords, analytics_id
6. **email** - smtp settings, from_email, from_name

## Next Steps

1. Run migration: `php artisan migrate:fresh`
2. Test endpoints with your authentication token
3. Create your first setting: general, social_media, etc.
4. Integrate with your frontend

## Need Help?

See `SETTING_MODULE_DOCUMENTATION.md` for complete documentation with more examples and detailed explanations.
