# Corrected cURL Examples for Image Upload

## ❌ Your Original Command (with errors)
```bash
curl --location 'localhost:8000/api/sections/footer' \
--header 'Accept: application/json, text/plain, */*' \
--header 'Authorization: Bearer kOEyps2WyRn1tsZyIEHXUzg65VYL8I9ACWJ1Rn1q298fe5eb' \
--form 'hero_image=@"postman-cloud:///1f00d371-4445-43f0-8c58-bc6357ca617e"' \
--form 'hero_images[1=@"/C:/Users/gamer/Downloads/shutterstock_141945937.webp"' \  # ❌ Missing ]
--form 'hero_images[2]=@"/C:/Users/gamer/Downloads/golden-retriever-dog-breed-info.jpeg"'
```

**Issues:**
1. Missing closing bracket: `hero_images[1=` should be `hero_images[1]=`
2. Inconsistent array indexing

## ✅ CORRECTED Command

### Option 1: Array with indices (recommended)
```bash
curl --location 'localhost:8000/api/sections/footer' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer kOEyps2WyRn1tsZyIEHXUzg65VYL8I9ACWJ1Rn1q298fe5eb' \
--form 'hero_image=@"/C:/Users/gamer/Downloads/hero.jpg"' \
--form 'hero_images[0]=@"/C:/Users/gamer/Downloads/shutterstock_141945937.webp"' \
--form 'hero_images[1]=@"/C:/Users/gamer/Downloads/golden-retriever-dog-breed-info.jpeg"'
```

### Option 2: Array without indices (also works)
```bash
curl --location 'localhost:8000/api/sections/footer' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer kOEyps2WyRn1tsZyIEHXUzg65VYL8I9ACWJ1Rn1q298fe5eb' \
--form 'hero_image=@"/C:/Users/gamer/Downloads/hero.jpg"' \
--form 'hero_images[]=@"/C:/Users/gamer/Downloads/shutterstock_141945937.webp"' \
--form 'hero_images[]=@"/C:/Users/gamer/Downloads/golden-retriever-dog-breed-info.jpeg"'
```

### Option 3: Simple field names (if you want)
```bash
curl --location 'localhost:8000/api/sections/footer' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer kOEyps2WyRn1tsZyIEHXUzg65VYL8I9ACWJ1Rn1q298fe5eb' \
--form 'single_image=@"/C:/Users/gamer/Downloads/hero.jpg"' \
--form 'multiple_images[]=@"/C:/Users/gamer/Downloads/image1.webp"' \
--form 'multiple_images[]=@"/C:/Users/gamer/Downloads/image2.jpeg"' \
--form 'multiple_images[]=@"/C:/Users/gamer/Downloads/image3.png"'
```

## Complete Example with Mixed Data

```bash
curl --location 'localhost:8000/api/sections/footer' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer YOUR_TOKEN_HERE' \
--form 'title="Footer Section"' \
--form 'description="Company footer with logo and social links"' \
--form 'logo_image=@"/path/to/logo.png"' \
--form 'social_images[]=@"/path/to/facebook-icon.png"' \
--form 'social_images[]=@"/path/to/twitter-icon.png"' \
--form 'social_images[]=@"/path/to/instagram-icon.png"' \
--form 'copyright="© 2025 Company Name"' \
--form 'active=true'
```

## Expected Response

```json
{
  "success": true,
  "message": "Section 'footer' created successfully",
  "data": {
    "id": 1,
    "name": "footer",
    "body": {
      "title": "Footer Section",
      "description": "Company footer with logo and social links",
      "logo_image": "http://localhost:8000/storage/sections/abc123def456.png",
      "social_images": [
        "http://localhost:8000/storage/sections/xyz789.png",
        "http://localhost:8000/storage/sections/qwe456.png",
        "http://localhost:8000/storage/sections/asd789.png"
      ],
      "copyright": "© 2025 Company Name",
      "active": true
    },
    "added_by": 1,
    "updated_by": 1,
    "created_at": "2025-10-06T12:00:00.000000Z",
    "updated_at": "2025-10-06T12:00:00.000000Z",
    "addedBy": {
      "id": 1,
      "name": "Admin User"
    },
    "updatedBy": {
      "id": 1,
      "name": "Admin User"
    }
  }
}
```

## Testing Your Upload

### 1. First, test with a single image
```bash
curl --location 'localhost:8000/api/sections/test' \
--header 'Authorization: Bearer YOUR_TOKEN' \
--form 'test_image=@"/C:/Users/gamer/Downloads/test.jpg"'
```

### 2. Then test with multiple images
```bash
curl --location 'localhost:8000/api/sections/test' \
--header 'Authorization: Bearer YOUR_TOKEN' \
--form 'test_images[]=@"/C:/Users/gamer/Downloads/image1.jpg"' \
--form 'test_images[]=@"/C:/Users/gamer/Downloads/image2.jpg"'
```

### 3. Verify the result
```bash
curl --location 'localhost:8000/api/sections/test'
```

## Common Issues & Solutions

### Issue: "only upload hero_image"
**Cause:** Syntax error in array field (missing bracket, wrong syntax)
**Solution:** Use correct syntax: `hero_images[]=@"file.jpg"` or `hero_images[0]=@"file.jpg"`

### Issue: Files not uploading
**Causes:**
- File path is incorrect (use absolute path)
- File doesn't exist at specified location
- Missing `@` symbol before file path
- Authorization token expired

### Issue: Getting 401 Unauthorized
**Solution:** Refresh your token or login again

## PowerShell Users (Windows)

If using PowerShell instead of bash/cmd, you may need to escape characters differently:

```powershell
curl --location 'localhost:8000/api/sections/footer' `
--header 'Authorization: Bearer YOUR_TOKEN' `
--form 'hero_image=@"C:\Users\gamer\Downloads\hero.jpg"' `
--form 'hero_images[]=@"C:\Users\gamer\Downloads\image1.webp"' `
--form 'hero_images[]=@"C:\Users\gamer\Downloads\image2.jpeg"'
```

## Postman Alternative

If cURL is giving you trouble, you can also use Postman:

1. Set method to **POST**
2. URL: `http://localhost:8000/api/sections/footer`
3. Headers:
   - `Authorization: Bearer YOUR_TOKEN`
4. Body → **form-data**:
   - `hero_image` → [File] → Select file
   - `hero_images` → [File] → Select file (you can add multiple rows with same key)
5. Click **Send**





